<?php
/**
 * Delete Comment Activity
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Triggers\Delete_Comment_Activity
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Delete_Comment_Activity extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddyboss';
    public $trigger = 'buddyboss_delete_comment_activity';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User deletes a reply from an activity stream message', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>deletes a reply</strong> from an activity stream message', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User deletes a reply from an activity stream message %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User deletes a reply from an activity stream message', 'automatorwp-pro' ),
            'action'            => 'bp_activity_delete_comment',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_buddyboss_get_activity_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $activity_id ID of the activity that has had a comment deleted from.
	 * @param int $comment_id  ID of the comment that was deleted.
     */
    public function listener( $activity_id, $comment_id ) {

        $user_id = bp_loggedin_user_id();

        $comment = new BP_Activity_Activity( $comment_id );
        
        // Trigger the comment deleted on an activity
        automatorwp_trigger_event( array(
            'trigger'                   => $this->trigger,
            'user_id'                   => $user_id,
            'activity_id'               => $activity_id,
            'activity_comment_id'       => $comment_id,
        ) );

    }

    /**
     * Register the required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_trigger_log_meta', array( $this, 'log_meta' ), 10, 6 );

        parent::hooks();
    }

    /**
     * Trigger custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return array
     */
    function log_meta( $log_meta, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Bail if action type don't match this action
        if( $trigger->type !== $this->trigger ) {
            return $log_meta;
        }

        $log_meta['activity_id'] = ( isset( $event['activity_id'] ) ? $event['activity_id'] : '' );
        
        return $log_meta;

    }


}

new AutomatorWP_BuddyBoss_Delete_Comment_Activity();